% S-Function demonstrating how to load the Phidget library as well as creating, opening and attaching to the Phidget
function [sys,x0,str,ts] = PhidgetInterfaceKit(t,x,u,flag, serial)

switch flag,

  %%%%%%%%%%%%%%%%%%
  % Initialization %
  %%%%%%%%%%%%%%%%%%
  case 0,
   [sys,x0,str,ts]=mdlInitializeSizes(serial);
  
  %%%%%%%%%%  
  % Update %
  %%%%%%%%%%
  case 2,                                               
    sys = mdlUpdate(t,x,u);
    
  %%%%%%%%%%
  % Output %
  %%%%%%%%%%
  case 3,                                               
    sys = mdlOutputs(t,x,u);    
    
  %%%%%%%%%%%%%
  % Terminate %
  %%%%%%%%%%%%%
  case 9,
    sys=mdlTerminate(t,x,u);

  otherwise
    error(['unhandled flag = ',num2str(flag)]);
end

%end sfundsc1

%
%=============================================================================
% mdlInitializeSizes
% Return the sizes, initial conditions, and sample times for the S-function.
%=============================================================================
%
function [sys,x0,str,ts]=mdlInitializeSizes(serial)

global handle;
global oldHandle;

if ~libisloaded('phidget21')
    loadlibrary('phidget21', 'phidget21Matlab.h');
end

ptr = libpointer('int32Ptr',0);


calllib('phidget21', 'CPhidgetInterfaceKit_create', ptr);
handle = get(ptr, 'Value');

%if the open call fails, then either the Phidget is not attached to the
%computer, or the application has already attached to the Phidget(ie, even
%when a simulation is not running, a change in the block parameter will run
%mdlInitializeSizes
if calllib('phidget21', 'CPhidget_open', handle, serial) ~= 0
    %the Phidget may have been opened when the simulation was not running, 
    %so the old handle becomes the current handle
    handle = oldHandle    
end

%application takes the next 2500ms to attach to the Phidget
if calllib('phidget21', 'CPhidget_waitForAttachment', handle, 2500) == 0
    disp('Attached to InterfaceKit')
    
    %if the block parameters changes while the simulation is not running,
    %then we will need to make a copy of the handle
    oldHandle = handle;
    
else
    disp('Could not attach to InterfaceKit')
end


sizes = simsizes;

sizes.NumContStates  = 0;
sizes.NumDiscStates  = 0;   
sizes.NumOutputs     = 0;
sizes.NumInputs      = 0;
sizes.DirFeedthrough = 0;
sizes.NumSampleTimes = 1;

sys = simsizes(sizes);
x0  = [];
str = [];
ts  = [-1 0]; 
% end mdlInitializeSizes

%
%=======================================================================
% mdlUpdate
% Handle discrete state updates, sample time hits, and major time step
% requirements.
%=======================================================================
%
function sys = mdlUpdate(t,x,u)
sys = [];
%end mdlUpdate

%
%=======================================================================
% mdlOutputs
% Return the output vector for the S-function
%=======================================================================
%
function sys = mdlOutputs(t,x,u)
sys = [];

%end mdlOutputs

%
%=============================================================================
% mdlTerminate
% Perform any end of simulation tasks.
%=============================================================================
%
function sys=mdlTerminate(t,x,u)
global handle;

% clean up
calllib('phidget21', 'CPhidget_close', handle);
calllib('phidget21', 'CPhidget_delete', handle);

sys = [];

% end mdlTerminate


